/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Rain
**
** DESCRIPTION:	Rain effect
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef RAIN_H
#define RAIN_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Rain_c_iMaxRainDrops = 512;
const int Rain_c_iMaxSplashes = 128;
const int Rain_c_iMinSpeed = 20;
const int Rain_c_iMaxSpeed = 60;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CRain
{
private:

	//class structures
	struct SRainDrop
	{
		ldwPoint	m_sStart;
		ldwPoint	m_sEnd;
		ldwPoint	m_sVel;
	};

	//class data
	SRainDrop		m_RainDrop[Rain_c_iMaxRainDrops];

	ldwPoint			m_sWorldPos;

	//class methods
	//setup
	public:		CRain();
	public:		~CRain();
	public:		void Reset(bool playSound = true);

	//process
	public:		void Update();
	public:		void Draw();
	public:		void Stop();

	//access
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CRain		Rain;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/